document.addEventListener("DOMContentLoaded", function () {
  const track = document.querySelector(".slider-track");
  const slides = Array.from(track.children);

  // 複製
  slides.forEach(slide => {
    const clone = slide.cloneNode(true);
    track.appendChild(clone);
  });

  const slideWidth = slides[0].offsetWidth;
  const margin = parseInt(getComputedStyle(slides[0]).marginRight || 0);
  const distance = (slideWidth + margin) * slides.length;

  track.style.setProperty('--scroll-distance', `-${distance}px`);
});
